package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpnConnectionsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    vpnConnectionIds: Optional[Iterable[VpnConnectionId]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest = {
    import DescribeVpnConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        vpnConnectionIds.map(value =>
          value.map { item =>
            VpnConnectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpnConnectionIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpnConnectionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpnConnectionsRequest.wrap(buildAwsValue())
}
object DescribeVpnConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpnConnectionsRequest =
      zio.aws.ec2.model.DescribeVpnConnectionsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpnConnectionIds.map(value => value),
        dryRun.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def vpnConnectionIds: Optional[List[VpnConnectionId]]
    def dryRun: Optional[Boolean]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVpnConnectionIds: ZIO[Any, AwsError, List[VpnConnectionId]] =
      AwsError.unwrapOptionField("vpnConnectionIds", vpnConnectionIds)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
  ) extends zio.aws.ec2.model.DescribeVpnConnectionsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val vpnConnectionIds: Optional[List[VpnConnectionId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnectionIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.VpnConnectionId(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest
  ): zio.aws.ec2.model.DescribeVpnConnectionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
