package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults,
  VerifiedAccessInstanceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessInstanceLoggingConfigurationsRequest(
    verifiedAccessInstanceIds: Optional[Iterable[VerifiedAccessInstanceId]] =
      Optional.Absent,
    maxResults: Optional[
      DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest = {
    import DescribeVerifiedAccessInstanceLoggingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest
      .builder()
      .optionallyWith(
        verifiedAccessInstanceIds.map(value =>
          value.map { item =>
            VerifiedAccessInstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.verifiedAccessInstanceIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessInstanceLoggingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest =
      zio.aws.ec2.model
        .DescribeVerifiedAccessInstanceLoggingConfigurationsRequest(
          verifiedAccessInstanceIds.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value),
          filters.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          dryRun.map(value => value)
        )
    def verifiedAccessInstanceIds: Optional[List[VerifiedAccessInstanceId]]
    def maxResults: Optional[
      DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults
    ]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getVerifiedAccessInstanceIds
        : ZIO[Any, AwsError, List[VerifiedAccessInstanceId]] = AwsError
      .unwrapOptionField("verifiedAccessInstanceIds", verifiedAccessInstanceIds)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest.ReadOnly {
    override val verifiedAccessInstanceIds
        : Optional[List[VerifiedAccessInstanceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessInstanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VerifiedAccessInstanceId(item)
        }.toList
      )
    override val maxResults: Optional[
      DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .DescribeVerifiedAccessInstanceLoggingConfigurationsMaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest
  ): zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
