package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayConnectPeersResponse(
    transitGatewayConnectPeers: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayConnectPeer]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse = {
    import DescribeTransitGatewayConnectPeersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse
      .builder()
      .optionallyWith(
        transitGatewayConnectPeers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayConnectPeers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayConnectPeersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse =
      zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse(
        transitGatewayConnectPeers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayConnectPeers
        : Optional[List[zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly]]
    def nextToken: Optional[String]
    def getTransitGatewayConnectPeers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayConnectPeers",
      transitGatewayConnectPeers
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly {
    override val transitGatewayConnectPeers
        : Optional[List[zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayConnectPeers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TransitGatewayConnectPeer.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly =
    new Wrapper(impl)
}
