package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIpamsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    ipams: Optional[Iterable[zio.aws.ec2.model.Ipam]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse = {
    import DescribeIpamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ipams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipams)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIpamsResponse.wrap(buildAwsValue())
}
object DescribeIpamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpamsResponse =
      zio.aws.ec2.model.DescribeIpamsResponse(
        nextToken.map(value => value),
        ipams.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def ipams: Optional[List[zio.aws.ec2.model.Ipam.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpams: ZIO[Any, AwsError, List[zio.aws.ec2.model.Ipam.ReadOnly]] =
      AwsError.unwrapOptionField("ipams", ipams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse
  ) extends zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipams: Optional[List[zio.aws.ec2.model.Ipam.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipams())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipam.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse
  ): zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly = new Wrapper(impl)
}
