package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{ResultRange, InstanceEventWindowId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeInstanceEventWindowsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceEventWindowIds: Optional[Iterable[InstanceEventWindowId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[ResultRange] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest = {
    import DescribeInstanceEventWindowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        instanceEventWindowIds.map(value =>
          value.map { item =>
            InstanceEventWindowId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceEventWindowIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => ResultRange.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.wrap(buildAwsValue())
}
object DescribeInstanceEventWindowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest =
      zio.aws.ec2.model.DescribeInstanceEventWindowsRequest(
        dryRun.map(value => value),
        instanceEventWindowIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def instanceEventWindowIds: Optional[List[InstanceEventWindowId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[ResultRange]
    def nextToken: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceEventWindowIds
        : ZIO[Any, AwsError, List[InstanceEventWindowId]] = AwsError
      .unwrapOptionField("instanceEventWindowIds", instanceEventWindowIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, ResultRange] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
  ) extends zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceEventWindowIds: Optional[List[InstanceEventWindowId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceEventWindowIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.InstanceEventWindowId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[ResultRange] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.ResultRange(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest
  ): zio.aws.ec2.model.DescribeInstanceEventWindowsRequest.ReadOnly =
    new Wrapper(impl)
}
