package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ImageId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImagesRequest(
    executableUsers: Optional[Iterable[String]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    imageIds: Optional[Iterable[ImageId]] = Optional.Absent,
    owners: Optional[Iterable[String]] = Optional.Absent,
    includeDeprecated: Optional[Boolean] = Optional.Absent,
    includeDisabled: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImagesRequest = {
    import DescribeImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
      .builder()
      .optionallyWith(
        executableUsers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.executableUsers)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            ImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(
        owners.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.owners)
      .optionallyWith(includeDeprecated.map(value => value: java.lang.Boolean))(
        _.includeDeprecated
      )
      .optionallyWith(includeDisabled.map(value => value: java.lang.Boolean))(
        _.includeDisabled
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImagesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeImagesRequest.wrap(buildAwsValue())
}
object DescribeImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImagesRequest =
      zio.aws.ec2.model.DescribeImagesRequest(
        executableUsers.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageIds.map(value => value),
        owners.map(value => value),
        includeDeprecated.map(value => value),
        includeDisabled.map(value => value),
        dryRun.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def executableUsers: Optional[List[String]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def imageIds: Optional[List[ImageId]]
    def owners: Optional[List[String]]
    def includeDeprecated: Optional[Boolean]
    def includeDisabled: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getExecutableUsers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("executableUsers", executableUsers)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getImageIds: ZIO[Any, AwsError, List[ImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getOwners: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("owners", owners)
    def getIncludeDeprecated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDeprecated", includeDeprecated)
    def getIncludeDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDisabled", includeDisabled)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
  ) extends zio.aws.ec2.model.DescribeImagesRequest.ReadOnly {
    override val executableUsers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.executableUsers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val imageIds: Optional[List[ImageId]] = zio.aws.core.internal
      .optionalFromNullable(impl.imageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ImageId(item)
        }.toList
      )
    override val owners: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.owners())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val includeDeprecated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeDeprecated())
      .map(value => value: Boolean)
    override val includeDisabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeDisabled())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
  ): zio.aws.ec2.model.DescribeImagesRequest.ReadOnly = new Wrapper(impl)
}
