package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DescribeDhcpOptionsMaxResults,
  DhcpOptionsId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDhcpOptionsRequest(
    dhcpOptionsIds: Optional[Iterable[DhcpOptionsId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeDhcpOptionsMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest = {
    import DescribeDhcpOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest
      .builder()
      .optionallyWith(
        dhcpOptionsIds.map(value =>
          value.map { item =>
            DhcpOptionsId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dhcpOptionsIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeDhcpOptionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeDhcpOptionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeDhcpOptionsRequest.wrap(buildAwsValue())
}
object DescribeDhcpOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeDhcpOptionsRequest =
      zio.aws.ec2.model.DescribeDhcpOptionsRequest(
        dhcpOptionsIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def dhcpOptionsIds: Optional[List[DhcpOptionsId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeDhcpOptionsMaxResults]
    def getDhcpOptionsIds: ZIO[Any, AwsError, List[DhcpOptionsId]] =
      AwsError.unwrapOptionField("dhcpOptionsIds", dhcpOptionsIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeDhcpOptionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest
  ) extends zio.aws.ec2.model.DescribeDhcpOptionsRequest.ReadOnly {
    override val dhcpOptionsIds: Optional[List[DhcpOptionsId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dhcpOptionsIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.DhcpOptionsId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeDhcpOptionsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeDhcpOptionsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest
  ): zio.aws.ec2.model.DescribeDhcpOptionsRequest.ReadOnly = new Wrapper(impl)
}
