package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeClientVpnRoutesMaxResults,
  ClientVpnEndpointId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnRoutesRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[DescribeClientVpnRoutesMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest = {
    import DescribeClientVpnRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeClientVpnRoutesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeClientVpnRoutesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnRoutesRequest.wrap(buildAwsValue())
}
object DescribeClientVpnRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnRoutesRequest =
      zio.aws.ec2.model.DescribeClientVpnRoutesRequest(
        clientVpnEndpointId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        dryRun.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[DescribeClientVpnRoutesMaxResults]
    def nextToken: Optional[NextToken]
    def dryRun: Optional[Boolean]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, DescribeClientVpnRoutesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
  ) extends zio.aws.ec2.model.DescribeClientVpnRoutesRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[DescribeClientVpnRoutesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeClientVpnRoutesMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest
  ): zio.aws.ec2.model.DescribeClientVpnRoutesRequest.ReadOnly = new Wrapper(
    impl
  )
}
