package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVolumeRequest(
    volumeId: VolumeId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest = {
    import DeleteVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
      .builder()
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVolumeRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVolumeRequest.wrap(buildAwsValue())
}
object DeleteVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVolumeRequest = zio.aws.ec2.model
      .DeleteVolumeRequest(volumeId, dryRun.map(value => value))
    def volumeId: VolumeId
    def dryRun: Optional[Boolean]
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
  ) extends zio.aws.ec2.model.DeleteVolumeRequest.ReadOnly {
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
  ): zio.aws.ec2.model.DeleteVolumeRequest.ReadOnly = new Wrapper(impl)
}
