package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSnapshotRequest(
    snapshotId: SnapshotId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest = {
    import DeleteSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
      .builder()
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteSnapshotRequest.ReadOnly =
    zio.aws.ec2.model.DeleteSnapshotRequest.wrap(buildAwsValue())
}
object DeleteSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSnapshotRequest = zio.aws.ec2.model
      .DeleteSnapshotRequest(snapshotId, dryRun.map(value => value))
    def snapshotId: SnapshotId
    def dryRun: Optional[Boolean]
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
  ) extends zio.aws.ec2.model.DeleteSnapshotRequest.ReadOnly {
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest
  ): zio.aws.ec2.model.DeleteSnapshotRequest.ReadOnly = new Wrapper(impl)
}
