package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PlacementGroupName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePlacementGroupRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    groupName: PlacementGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest = {
    import DeletePlacementGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .groupName(PlacementGroupName.unwrap(groupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeletePlacementGroupRequest.ReadOnly =
    zio.aws.ec2.model.DeletePlacementGroupRequest.wrap(buildAwsValue())
}
object DeletePlacementGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeletePlacementGroupRequest =
      zio.aws.ec2.model
        .DeletePlacementGroupRequest(dryRun.map(value => value), groupName)
    def dryRun: Optional[Boolean]
    def groupName: PlacementGroupName
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getGroupName: ZIO[Any, Nothing, PlacementGroupName] =
      ZIO.succeed(groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
  ) extends zio.aws.ec2.model.DeletePlacementGroupRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val groupName: PlacementGroupName =
      zio.aws.ec2.model.primitives.PlacementGroupName(impl.groupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest
  ): zio.aws.ec2.model.DeletePlacementGroupRequest.ReadOnly = new Wrapper(impl)
}
