package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLaunchTemplateResponse(
    launchTemplate: Optional[zio.aws.ec2.model.LaunchTemplate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse = {
    import DeleteLaunchTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse
      .builder()
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly =
    zio.aws.ec2.model.DeleteLaunchTemplateResponse.wrap(buildAwsValue())
}
object DeleteLaunchTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLaunchTemplateResponse =
      zio.aws.ec2.model.DeleteLaunchTemplateResponse(
        launchTemplate.map(value => value.asEditable)
      )
    def launchTemplate: Optional[zio.aws.ec2.model.LaunchTemplate.ReadOnly]
    def getLaunchTemplate
        : ZIO[Any, AwsError, zio.aws.ec2.model.LaunchTemplate.ReadOnly] =
      AwsError.unwrapOptionField("launchTemplate", launchTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse
  ) extends zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly {
    override val launchTemplate
        : Optional[zio.aws.ec2.model.LaunchTemplate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplate())
        .map(value => zio.aws.ec2.model.LaunchTemplate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse
  ): zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly = new Wrapper(impl)
}
