package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{KeyPairId, KeyPairName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteKeyPairRequest(
    keyName: Optional[KeyPairName] = Optional.Absent,
    keyPairId: Optional[KeyPairId] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest = {
    import DeleteKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
      .builder()
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        keyPairId.map(value => KeyPairId.unwrap(value): java.lang.String)
      )(_.keyPairId)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteKeyPairRequest.ReadOnly =
    zio.aws.ec2.model.DeleteKeyPairRequest.wrap(buildAwsValue())
}
object DeleteKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteKeyPairRequest =
      zio.aws.ec2.model.DeleteKeyPairRequest(
        keyName.map(value => value),
        keyPairId.map(value => value),
        dryRun.map(value => value)
      )
    def keyName: Optional[KeyPairName]
    def keyPairId: Optional[KeyPairId]
    def dryRun: Optional[Boolean]
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getKeyPairId: ZIO[Any, AwsError, KeyPairId] =
      AwsError.unwrapOptionField("keyPairId", keyPairId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
  ) extends zio.aws.ec2.model.DeleteKeyPairRequest.ReadOnly {
    override val keyName: Optional[KeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val keyPairId: Optional[KeyPairId] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPairId())
      .map(value => zio.aws.ec2.model.primitives.KeyPairId(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest
  ): zio.aws.ec2.model.DeleteKeyPairRequest.ReadOnly = new Wrapper(impl)
}
