package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteIpamScopeRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamScopeId: IpamScopeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest = {
    import DeleteIpamScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamScopeRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamScopeRequest.wrap(buildAwsValue())
}
object DeleteIpamScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamScopeRequest = zio.aws.ec2.model
      .DeleteIpamScopeRequest(dryRun.map(value => value), ipamScopeId)
    def dryRun: Optional[Boolean]
    def ipamScopeId: IpamScopeId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
  ) extends zio.aws.ec2.model.DeleteIpamScopeRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest
  ): zio.aws.ec2.model.DeleteIpamScopeRequest.ReadOnly = new Wrapper(impl)
}
