package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteIpamRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    ipamId: IpamId,
    cascade: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamRequest = {
    import DeleteIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .ipamId(IpamId.unwrap(ipamId): java.lang.String)
      .optionallyWith(cascade.map(value => value: java.lang.Boolean))(_.cascade)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamRequest.wrap(buildAwsValue())
}
object DeleteIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamRequest =
      zio.aws.ec2.model.DeleteIpamRequest(
        dryRun.map(value => value),
        ipamId,
        cascade.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def ipamId: IpamId
    def cascade: Optional[Boolean]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getIpamId: ZIO[Any, Nothing, IpamId] = ZIO.succeed(ipamId)
    def getCascade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cascade", cascade)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ) extends zio.aws.ec2.model.DeleteIpamRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val ipamId: IpamId =
      zio.aws.ec2.model.primitives.IpamId(impl.ipamId())
    override val cascade: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cascade())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ): zio.aws.ec2.model.DeleteIpamRequest.ReadOnly = new Wrapper(impl)
}
