package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DhcpOptionsId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDhcpOptionsRequest(
    dhcpOptionsId: DhcpOptionsId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest = {
    import DeleteDhcpOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest
      .builder()
      .dhcpOptionsId(DhcpOptionsId.unwrap(dhcpOptionsId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteDhcpOptionsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteDhcpOptionsRequest.wrap(buildAwsValue())
}
object DeleteDhcpOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteDhcpOptionsRequest =
      zio.aws.ec2.model
        .DeleteDhcpOptionsRequest(dhcpOptionsId, dryRun.map(value => value))
    def dhcpOptionsId: DhcpOptionsId
    def dryRun: Optional[Boolean]
    def getDhcpOptionsId: ZIO[Any, Nothing, DhcpOptionsId] =
      ZIO.succeed(dhcpOptionsId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest
  ) extends zio.aws.ec2.model.DeleteDhcpOptionsRequest.ReadOnly {
    override val dhcpOptionsId: DhcpOptionsId =
      zio.aws.ec2.model.primitives.DhcpOptionsId(impl.dhcpOptionsId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest
  ): zio.aws.ec2.model.DeleteDhcpOptionsRequest.ReadOnly = new Wrapper(impl)
}
