package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessTrustProviderRequest(
    trustProviderType: zio.aws.ec2.model.TrustProviderType,
    userTrustProviderType: Optional[zio.aws.ec2.model.UserTrustProviderType] =
      Optional.Absent,
    deviceTrustProviderType: Optional[
      zio.aws.ec2.model.DeviceTrustProviderType
    ] = Optional.Absent,
    oidcOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions
    ] = Optional.Absent,
    deviceOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions
    ] = Optional.Absent,
    policyReferenceName: String,
    description: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest = {
    import CreateVerifiedAccessTrustProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest
      .builder()
      .trustProviderType(trustProviderType.unwrap)
      .optionallyWith(userTrustProviderType.map(value => value.unwrap))(
        _.userTrustProviderType
      )
      .optionallyWith(deviceTrustProviderType.map(value => value.unwrap))(
        _.deviceTrustProviderType
      )
      .optionallyWith(oidcOptions.map(value => value.buildAwsValue()))(
        _.oidcOptions
      )
      .optionallyWith(deviceOptions.map(value => value.buildAwsValue()))(
        _.deviceOptions
      )
      .policyReferenceName(policyReferenceName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessTrustProviderRequest.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessTrustProviderRequest
      .wrap(buildAwsValue())
}
object CreateVerifiedAccessTrustProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVerifiedAccessTrustProviderRequest =
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderRequest(
        trustProviderType,
        userTrustProviderType.map(value => value),
        deviceTrustProviderType.map(value => value),
        oidcOptions.map(value => value.asEditable),
        deviceOptions.map(value => value.asEditable),
        policyReferenceName,
        description.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        dryRun.map(value => value),
        sseSpecification.map(value => value.asEditable)
      )
    def trustProviderType: zio.aws.ec2.model.TrustProviderType
    def userTrustProviderType: Optional[zio.aws.ec2.model.UserTrustProviderType]
    def deviceTrustProviderType
        : Optional[zio.aws.ec2.model.DeviceTrustProviderType]
    def oidcOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions.ReadOnly
    ]
    def deviceOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions.ReadOnly
    ]
    def policyReferenceName: String
    def description: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ]
    def getTrustProviderType
        : ZIO[Any, Nothing, zio.aws.ec2.model.TrustProviderType] =
      ZIO.succeed(trustProviderType)
    def getUserTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserTrustProviderType] =
      AwsError.unwrapOptionField("userTrustProviderType", userTrustProviderType)
    def getDeviceTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.DeviceTrustProviderType] =
      AwsError.unwrapOptionField(
        "deviceTrustProviderType",
        deviceTrustProviderType
      )
    def getOidcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions.ReadOnly
    ] = AwsError.unwrapOptionField("oidcOptions", oidcOptions)
    def getDeviceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions.ReadOnly
    ] = AwsError.unwrapOptionField("deviceOptions", deviceOptions)
    def getPolicyReferenceName: ZIO[Any, Nothing, String] =
      ZIO.succeed(policyReferenceName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest
  ) extends zio.aws.ec2.model.CreateVerifiedAccessTrustProviderRequest.ReadOnly {
    override val trustProviderType: zio.aws.ec2.model.TrustProviderType =
      zio.aws.ec2.model.TrustProviderType.wrap(impl.trustProviderType())
    override val userTrustProviderType
        : Optional[zio.aws.ec2.model.UserTrustProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userTrustProviderType())
        .map(value => zio.aws.ec2.model.UserTrustProviderType.wrap(value))
    override val deviceTrustProviderType
        : Optional[zio.aws.ec2.model.DeviceTrustProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceTrustProviderType())
        .map(value => zio.aws.ec2.model.DeviceTrustProviderType.wrap(value))
    override val oidcOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oidcOptions())
      .map(value =>
        zio.aws.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions
          .wrap(value)
      )
    override val deviceOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceOptions())
      .map(value =>
        zio.aws.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions
          .wrap(value)
      )
    override val policyReferenceName: String =
      impl.policyReferenceName(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest
  ): zio.aws.ec2.model.CreateVerifiedAccessTrustProviderRequest.ReadOnly =
    new Wrapper(impl)
}
