package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  CertificateArn,
  VerifiedAccessGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessEndpointRequest(
    verifiedAccessGroupId: VerifiedAccessGroupId,
    endpointType: zio.aws.ec2.model.VerifiedAccessEndpointType,
    attachmentType: zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType,
    domainCertificateArn: CertificateArn,
    applicationDomain: String,
    endpointDomainPrefix: String,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    loadBalancerOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions
    ] = Optional.Absent,
    networkInterfaceOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions
    ] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    policyDocument: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest = {
    import CreateVerifiedAccessEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest
      .builder()
      .verifiedAccessGroupId(
        VerifiedAccessGroupId.unwrap(verifiedAccessGroupId): java.lang.String
      )
      .endpointType(endpointType.unwrap)
      .attachmentType(attachmentType.unwrap)
      .domainCertificateArn(
        CertificateArn.unwrap(domainCertificateArn): java.lang.String
      )
      .applicationDomain(applicationDomain: java.lang.String)
      .endpointDomainPrefix(endpointDomainPrefix: java.lang.String)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(loadBalancerOptions.map(value => value.buildAwsValue()))(
        _.loadBalancerOptions
      )
      .optionallyWith(
        networkInterfaceOptions.map(value => value.buildAwsValue())
      )(_.networkInterfaceOptions)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessEndpointRequest.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessEndpointRequest.wrap(buildAwsValue())
}
object CreateVerifiedAccessEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVerifiedAccessEndpointRequest =
      zio.aws.ec2.model.CreateVerifiedAccessEndpointRequest(
        verifiedAccessGroupId,
        endpointType,
        attachmentType,
        domainCertificateArn,
        applicationDomain,
        endpointDomainPrefix,
        securityGroupIds.map(value => value),
        loadBalancerOptions.map(value => value.asEditable),
        networkInterfaceOptions.map(value => value.asEditable),
        description.map(value => value),
        policyDocument.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        dryRun.map(value => value),
        sseSpecification.map(value => value.asEditable)
      )
    def verifiedAccessGroupId: VerifiedAccessGroupId
    def endpointType: zio.aws.ec2.model.VerifiedAccessEndpointType
    def attachmentType: zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType
    def domainCertificateArn: CertificateArn
    def applicationDomain: String
    def endpointDomainPrefix: String
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def loadBalancerOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ]
    def networkInterfaceOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions.ReadOnly
    ]
    def description: Optional[String]
    def policyDocument: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Optional[String]
    def dryRun: Optional[Boolean]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ]
    def getVerifiedAccessGroupId: ZIO[Any, Nothing, VerifiedAccessGroupId] =
      ZIO.succeed(verifiedAccessGroupId)
    def getEndpointType
        : ZIO[Any, Nothing, zio.aws.ec2.model.VerifiedAccessEndpointType] =
      ZIO.succeed(endpointType)
    def getAttachmentType: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType
    ] = ZIO.succeed(attachmentType)
    def getDomainCertificateArn: ZIO[Any, Nothing, CertificateArn] =
      ZIO.succeed(domainCertificateArn)
    def getApplicationDomain: ZIO[Any, Nothing, String] =
      ZIO.succeed(applicationDomain)
    def getEndpointDomainPrefix: ZIO[Any, Nothing, String] =
      ZIO.succeed(endpointDomainPrefix)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getLoadBalancerOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerOptions", loadBalancerOptions)
    def getNetworkInterfaceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkInterfaceOptions",
      networkInterfaceOptions
    )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest
  ) extends zio.aws.ec2.model.CreateVerifiedAccessEndpointRequest.ReadOnly {
    override val verifiedAccessGroupId: VerifiedAccessGroupId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessGroupId(impl.verifiedAccessGroupId())
    override val endpointType: zio.aws.ec2.model.VerifiedAccessEndpointType =
      zio.aws.ec2.model.VerifiedAccessEndpointType.wrap(impl.endpointType())
    override val attachmentType
        : zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType =
      zio.aws.ec2.model.VerifiedAccessEndpointAttachmentType
        .wrap(impl.attachmentType())
    override val domainCertificateArn: CertificateArn =
      zio.aws.ec2.model.primitives.CertificateArn(impl.domainCertificateArn())
    override val applicationDomain: String = impl.applicationDomain(): String
    override val endpointDomainPrefix: String =
      impl.endpointDomainPrefix(): String
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val loadBalancerOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerOptions())
      .map(value =>
        zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions
          .wrap(value)
      )
    override val networkInterfaceOptions: Optional[
      zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceOptions())
      .map(value =>
        zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions.wrap(value)
      )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest
  ): zio.aws.ec2.model.CreateVerifiedAccessEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
