package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ResourceArn,
  LocalGatewayRoutetableId,
  Ipv4PoolCoipId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CoipPool(
    poolId: Optional[Ipv4PoolCoipId] = Optional.Absent,
    poolCidrs: Optional[Iterable[String]] = Optional.Absent,
    localGatewayRouteTableId: Optional[LocalGatewayRoutetableId] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    poolArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.CoipPool = {
    import CoipPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CoipPool
      .builder()
      .optionallyWith(
        poolId.map(value => Ipv4PoolCoipId.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(
        poolCidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.poolCidrs)
      .optionallyWith(
        localGatewayRouteTableId.map(value =>
          LocalGatewayRoutetableId.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        poolArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.poolArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CoipPool.ReadOnly =
    zio.aws.ec2.model.CoipPool.wrap(buildAwsValue())
}
object CoipPool {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.CoipPool] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CoipPool = zio.aws.ec2.model.CoipPool(
      poolId.map(value => value),
      poolCidrs.map(value => value),
      localGatewayRouteTableId.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      poolArn.map(value => value)
    )
    def poolId: Optional[Ipv4PoolCoipId]
    def poolCidrs: Optional[List[String]]
    def localGatewayRouteTableId: Optional[LocalGatewayRoutetableId]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def poolArn: Optional[ResourceArn]
    def getPoolId: ZIO[Any, AwsError, Ipv4PoolCoipId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getPoolCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("poolCidrs", poolCidrs)
    def getLocalGatewayRouteTableId
        : ZIO[Any, AwsError, LocalGatewayRoutetableId] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPoolArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("poolArn", poolArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CoipPool
  ) extends zio.aws.ec2.model.CoipPool.ReadOnly {
    override val poolId: Optional[Ipv4PoolCoipId] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => zio.aws.ec2.model.primitives.Ipv4PoolCoipId(value))
    override val poolCidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.poolCidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val localGatewayRouteTableId: Optional[LocalGatewayRoutetableId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableId())
        .map(value =>
          zio.aws.ec2.model.primitives.LocalGatewayRoutetableId(value)
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val poolArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.poolArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CoipPool
  ): zio.aws.ec2.model.CoipPool.ReadOnly = new Wrapper(impl)
}
