package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CertificateAuthentication(
    clientRootCertificateChain: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CertificateAuthentication = {
    import CertificateAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CertificateAuthentication
      .builder()
      .optionallyWith(
        clientRootCertificateChain.map(value => value: java.lang.String)
      )(_.clientRootCertificateChain)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CertificateAuthentication.ReadOnly =
    zio.aws.ec2.model.CertificateAuthentication.wrap(buildAwsValue())
}
object CertificateAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CertificateAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CertificateAuthentication =
      zio.aws.ec2.model.CertificateAuthentication(
        clientRootCertificateChain.map(value => value)
      )
    def clientRootCertificateChain: Optional[String]
    def getClientRootCertificateChain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "clientRootCertificateChain",
        clientRootCertificateChain
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CertificateAuthentication
  ) extends zio.aws.ec2.model.CertificateAuthentication.ReadOnly {
    override val clientRootCertificateChain: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRootCertificateChain())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CertificateAuthentication
  ): zio.aws.ec2.model.CertificateAuthentication.ReadOnly = new Wrapper(impl)
}
