package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CapacityReservationInstancePlatform {
  def unwrap: software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform
}
object CapacityReservationInstancePlatform {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform
  ): zio.aws.ec2.model.CapacityReservationInstancePlatform = value match {
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_UNIX =>
      val r = `Linux/UNIX`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RED_HAT_ENTERPRISE_LINUX =>
      val r = `Red Hat Enterprise Linux`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.SUSE_LINUX =>
      val r = `SUSE Linux`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS =>
      val r = Windows
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER =>
      val r = `Windows with SQL Server`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER_ENTERPRISE =>
      val r = `Windows with SQL Server Enterprise`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER_STANDARD =>
      val r = `Windows with SQL Server Standard`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER_WEB =>
      val r = `Windows with SQL Server Web`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_WITH_SQL_SERVER_STANDARD =>
      val r = `Linux with SQL Server Standard`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_WITH_SQL_SERVER_WEB =>
      val r = `Linux with SQL Server Web`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_WITH_SQL_SERVER_ENTERPRISE =>
      val r = `Linux with SQL Server Enterprise`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_SQL_SERVER_STANDARD =>
      val r = `RHEL with SQL Server Standard`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_SQL_SERVER_ENTERPRISE =>
      val r = `RHEL with SQL Server Enterprise`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_SQL_SERVER_WEB =>
      val r = `RHEL with SQL Server Web`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_HA =>
      val r = `RHEL with HA`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_HA_AND_SQL_SERVER_STANDARD =>
      val r = `RHEL with HA and SQL Server Standard`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_HA_AND_SQL_SERVER_ENTERPRISE =>
      val r = `RHEL with HA and SQL Server Enterprise`
      r
    case software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.UBUNTU_PRO =>
      val r = `Ubuntu Pro`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.UNKNOWN_TO_SDK_VERSION
  }
  case object `Linux/UNIX`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_UNIX
  }
  case object `Red Hat Enterprise Linux`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RED_HAT_ENTERPRISE_LINUX
  }
  case object `SUSE Linux`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.SUSE_LINUX
  }
  case object Windows
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS
  }
  case object `Windows with SQL Server`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER
  }
  case object `Windows with SQL Server Enterprise`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER_ENTERPRISE
  }
  case object `Windows with SQL Server Standard`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER_STANDARD
  }
  case object `Windows with SQL Server Web`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.WINDOWS_WITH_SQL_SERVER_WEB
  }
  case object `Linux with SQL Server Standard`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_WITH_SQL_SERVER_STANDARD
  }
  case object `Linux with SQL Server Web`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_WITH_SQL_SERVER_WEB
  }
  case object `Linux with SQL Server Enterprise`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.LINUX_WITH_SQL_SERVER_ENTERPRISE
  }
  case object `RHEL with SQL Server Standard`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_SQL_SERVER_STANDARD
  }
  case object `RHEL with SQL Server Enterprise`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_SQL_SERVER_ENTERPRISE
  }
  case object `RHEL with SQL Server Web`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_SQL_SERVER_WEB
  }
  case object `RHEL with HA`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_HA
  }
  case object `RHEL with HA and SQL Server Standard`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_HA_AND_SQL_SERVER_STANDARD
  }
  case object `RHEL with HA and SQL Server Enterprise`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.RHEL_WITH_HA_AND_SQL_SERVER_ENTERPRISE
  }
  case object `Ubuntu Pro`
      extends zio.aws.ec2.model.CapacityReservationInstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform =
      software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform.UBUNTU_PRO
  }
}
