package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SpotInstanceRequestId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelSpotInstanceRequestsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    spotInstanceRequestIds: Iterable[SpotInstanceRequestId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest = {
    import CancelSpotInstanceRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .spotInstanceRequestIds(spotInstanceRequestIds.map { item =>
        SpotInstanceRequestId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.ReadOnly =
    zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.wrap(buildAwsValue())
}
object CancelSpotInstanceRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotInstanceRequestsRequest =
      zio.aws.ec2.model.CancelSpotInstanceRequestsRequest(
        dryRun.map(value => value),
        spotInstanceRequestIds
      )
    def dryRun: Optional[Boolean]
    def spotInstanceRequestIds: List[SpotInstanceRequestId]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getSpotInstanceRequestIds
        : ZIO[Any, Nothing, List[SpotInstanceRequestId]] =
      ZIO.succeed(spotInstanceRequestIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
  ) extends zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val spotInstanceRequestIds: List[SpotInstanceRequestId] = impl
      .spotInstanceRequestIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SpotInstanceRequestId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest
  ): zio.aws.ec2.model.CancelSpotInstanceRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
