package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImportTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelImportTaskRequest(
    cancelReason: Optional[String] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    importTaskId: Optional[ImportTaskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest = {
    import CancelImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
      .builder()
      .optionallyWith(cancelReason.map(value => value: java.lang.String))(
        _.cancelReason
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        importTaskId.map(value => ImportTaskId.unwrap(value): java.lang.String)
      )(_.importTaskId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelImportTaskRequest.ReadOnly =
    zio.aws.ec2.model.CancelImportTaskRequest.wrap(buildAwsValue())
}
object CancelImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelImportTaskRequest =
      zio.aws.ec2.model.CancelImportTaskRequest(
        cancelReason.map(value => value),
        dryRun.map(value => value),
        importTaskId.map(value => value)
      )
    def cancelReason: Optional[String]
    def dryRun: Optional[Boolean]
    def importTaskId: Optional[ImportTaskId]
    def getCancelReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cancelReason", cancelReason)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getImportTaskId: ZIO[Any, AwsError, ImportTaskId] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
  ) extends zio.aws.ec2.model.CancelImportTaskRequest.ReadOnly {
    override val cancelReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cancelReason())
      .map(value => value: String)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val importTaskId: Optional[ImportTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.importTaskId())
      .map(value => zio.aws.ec2.model.primitives.ImportTaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest
  ): zio.aws.ec2.model.CancelImportTaskRequest.ReadOnly = new Wrapper(impl)
}
