package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CapacityReservationFleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelCapacityReservationFleetsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    capacityReservationFleetIds: Iterable[CapacityReservationFleetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest = {
    import CancelCapacityReservationFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .capacityReservationFleetIds(capacityReservationFleetIds.map { item =>
        CapacityReservationFleetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelCapacityReservationFleetsRequest.ReadOnly =
    zio.aws.ec2.model.CancelCapacityReservationFleetsRequest
      .wrap(buildAwsValue())
}
object CancelCapacityReservationFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelCapacityReservationFleetsRequest =
      zio.aws.ec2.model.CancelCapacityReservationFleetsRequest(
        dryRun.map(value => value),
        capacityReservationFleetIds
      )
    def dryRun: Optional[Boolean]
    def capacityReservationFleetIds: List[CapacityReservationFleetId]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getCapacityReservationFleetIds
        : ZIO[Any, Nothing, List[CapacityReservationFleetId]] =
      ZIO.succeed(capacityReservationFleetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest
  ) extends zio.aws.ec2.model.CancelCapacityReservationFleetsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val capacityReservationFleetIds: List[CapacityReservationFleetId] =
      impl
        .capacityReservationFleetIds()
        .asScala
        .map { item =>
          zio.aws.ec2.model.primitives.CapacityReservationFleetId(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest
  ): zio.aws.ec2.model.CancelCapacityReservationFleetsRequest.ReadOnly =
    new Wrapper(impl)
}
