package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{NetworkInterfaceId, InstanceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachNetworkInterfaceRequest(
    deviceIndex: Integer,
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceId: InstanceId,
    networkInterfaceId: NetworkInterfaceId,
    networkCardIndex: Optional[Integer] = Optional.Absent,
    enaSrdSpecification: Optional[zio.aws.ec2.model.EnaSrdSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest = {
    import AttachNetworkInterfaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
      .builder()
      .deviceIndex(deviceIndex: java.lang.Integer)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(networkCardIndex.map(value => value: java.lang.Integer))(
        _.networkCardIndex
      )
      .optionallyWith(enaSrdSpecification.map(value => value.buildAwsValue()))(
        _.enaSrdSpecification
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachNetworkInterfaceRequest.ReadOnly =
    zio.aws.ec2.model.AttachNetworkInterfaceRequest.wrap(buildAwsValue())
}
object AttachNetworkInterfaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachNetworkInterfaceRequest =
      zio.aws.ec2.model.AttachNetworkInterfaceRequest(
        deviceIndex,
        dryRun.map(value => value),
        instanceId,
        networkInterfaceId,
        networkCardIndex.map(value => value),
        enaSrdSpecification.map(value => value.asEditable)
      )
    def deviceIndex: Integer
    def dryRun: Optional[Boolean]
    def instanceId: InstanceId
    def networkInterfaceId: NetworkInterfaceId
    def networkCardIndex: Optional[Integer]
    def enaSrdSpecification
        : Optional[zio.aws.ec2.model.EnaSrdSpecification.ReadOnly]
    def getDeviceIndex: ZIO[Any, Nothing, Integer] = ZIO.succeed(deviceIndex)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
    def getEnaSrdSpecification
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnaSrdSpecification.ReadOnly] =
      AwsError.unwrapOptionField("enaSrdSpecification", enaSrdSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
  ) extends zio.aws.ec2.model.AttachNetworkInterfaceRequest.ReadOnly {
    override val deviceIndex: Integer = impl.deviceIndex(): Integer
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val networkCardIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.networkCardIndex())
      .map(value => value: Integer)
    override val enaSrdSpecification
        : Optional[zio.aws.ec2.model.EnaSrdSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enaSrdSpecification())
        .map(value => zio.aws.ec2.model.EnaSrdSpecification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest
  ): zio.aws.ec2.model.AttachNetworkInterfaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
