package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class VpcPeeringConnection(
    accepterVpcInfo: Optional[zio.aws.ec2.model.VpcPeeringConnectionVpcInfo] =
      Optional.Absent,
    expirationTime: Optional[DateTime] = Optional.Absent,
    requesterVpcInfo: Optional[zio.aws.ec2.model.VpcPeeringConnectionVpcInfo] =
      Optional.Absent,
    status: Optional[zio.aws.ec2.model.VpcPeeringConnectionStateReason] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    vpcPeeringConnectionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcPeeringConnection = {
    import VpcPeeringConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnection
      .builder()
      .optionallyWith(accepterVpcInfo.map(value => value.buildAwsValue()))(
        _.accepterVpcInfo
      )
      .optionallyWith(
        expirationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.expirationTime)
      .optionallyWith(requesterVpcInfo.map(value => value.buildAwsValue()))(
        _.requesterVpcInfo
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcPeeringConnection.ReadOnly =
    zio.aws.ec2.model.VpcPeeringConnection.wrap(buildAwsValue())
}
object VpcPeeringConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcPeeringConnection =
      zio.aws.ec2.model.VpcPeeringConnection(
        accepterVpcInfo.map(value => value.asEditable),
        expirationTime.map(value => value),
        requesterVpcInfo.map(value => value.asEditable),
        status.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcPeeringConnectionId.map(value => value)
      )
    def accepterVpcInfo
        : Optional[zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly]
    def expirationTime: Optional[DateTime]
    def requesterVpcInfo
        : Optional[zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly]
    def status
        : Optional[zio.aws.ec2.model.VpcPeeringConnectionStateReason.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcPeeringConnectionId: Optional[String]
    def getAccepterVpcInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly
    ] = AwsError.unwrapOptionField("accepterVpcInfo", accepterVpcInfo)
    def getExpirationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getRequesterVpcInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly
    ] = AwsError.unwrapOptionField("requesterVpcInfo", requesterVpcInfo)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcPeeringConnectionStateReason.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnection
  ) extends zio.aws.ec2.model.VpcPeeringConnection.ReadOnly {
    override val accepterVpcInfo
        : Optional[zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accepterVpcInfo())
        .map(value => zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.wrap(value))
    override val expirationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val requesterVpcInfo
        : Optional[zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requesterVpcInfo())
        .map(value => zio.aws.ec2.model.VpcPeeringConnectionVpcInfo.wrap(value))
    override val status
        : Optional[zio.aws.ec2.model.VpcPeeringConnectionStateReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.ec2.model.VpcPeeringConnectionStateReason.wrap(value)
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val vpcPeeringConnectionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnection
  ): zio.aws.ec2.model.VpcPeeringConnection.ReadOnly = new Wrapper(impl)
}
