package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableAnnouncementId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayRouteTablePropagation(
    transitGatewayAttachmentId: Optional[String] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayPropagationState] =
      Optional.Absent,
    transitGatewayRouteTableAnnouncementId: Optional[
      TransitGatewayRouteTableAnnouncementId
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation = {
    import TransitGatewayRouteTablePropagation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        transitGatewayRouteTableAnnouncementId.map(value =>
          TransitGatewayRouteTableAnnouncementId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableAnnouncementId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRouteTablePropagation.wrap(buildAwsValue())
}
object TransitGatewayRouteTablePropagation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRouteTablePropagation =
      zio.aws.ec2.model.TransitGatewayRouteTablePropagation(
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        state.map(value => value),
        transitGatewayRouteTableAnnouncementId.map(value => value)
      )
    def transitGatewayAttachmentId: Optional[String]
    def resourceId: Optional[String]
    def resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def state: Optional[zio.aws.ec2.model.TransitGatewayPropagationState]
    def transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayPropagationState] =
      AwsError.unwrapOptionField("state", state)
    def getTransitGatewayRouteTableAnnouncementId
        : ZIO[Any, AwsError, TransitGatewayRouteTableAnnouncementId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableAnnouncementId",
        transitGatewayRouteTableAnnouncementId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
  ) extends zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly {
    override val transitGatewayAttachmentId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachmentId())
        .map(value => value: String)
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
        )
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayPropagationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPropagationState.wrap(value)
        )
    override val transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableAnnouncementId())
        .map(value =>
          zio.aws.ec2.model.primitives
            .TransitGatewayRouteTableAnnouncementId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTablePropagation
  ): zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly =
    new Wrapper(impl)
}
