package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TerminateInstancesRequest(instanceIds: Iterable[InstanceId]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest = {
    import TerminateInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest
      .builder()
      .instanceIds(instanceIds.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TerminateInstancesRequest.ReadOnly =
    zio.aws.ec2.model.TerminateInstancesRequest.wrap(buildAwsValue())
}
object TerminateInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateInstancesRequest =
      zio.aws.ec2.model.TerminateInstancesRequest(instanceIds)
    def instanceIds: List[InstanceId]
    def getInstanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest
  ) extends zio.aws.ec2.model.TerminateInstancesRequest.ReadOnly {
    override val instanceIds: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.InstanceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest
  ): zio.aws.ec2.model.TerminateInstancesRequest.ReadOnly = new Wrapper(impl)
}
