package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SpotInstanceState {
  def unwrap: software.amazon.awssdk.services.ec2.model.SpotInstanceState
}
object SpotInstanceState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SpotInstanceState
  ): zio.aws.ec2.model.SpotInstanceState = value match {
    case software.amazon.awssdk.services.ec2.model.SpotInstanceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceState.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceState.CLOSED =>
      val r = closed
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceState.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SpotInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceState =
      software.amazon.awssdk.services.ec2.model.SpotInstanceState.UNKNOWN_TO_SDK_VERSION
  }
  case object open extends zio.aws.ec2.model.SpotInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceState =
      software.amazon.awssdk.services.ec2.model.SpotInstanceState.OPEN
  }
  case object active extends zio.aws.ec2.model.SpotInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceState =
      software.amazon.awssdk.services.ec2.model.SpotInstanceState.ACTIVE
  }
  case object closed extends zio.aws.ec2.model.SpotInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceState =
      software.amazon.awssdk.services.ec2.model.SpotInstanceState.CLOSED
  }
  case object cancelled extends zio.aws.ec2.model.SpotInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceState =
      software.amazon.awssdk.services.ec2.model.SpotInstanceState.CANCELLED
  }
  case object failed extends zio.aws.ec2.model.SpotInstanceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceState =
      software.amazon.awssdk.services.ec2.model.SpotInstanceState.FAILED
  }
}
