package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{HostReservationId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Purchase(
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    duration: Optional[Integer] = Optional.Absent,
    hostIdSet: Optional[Iterable[String]] = Optional.Absent,
    hostReservationId: Optional[HostReservationId] = Optional.Absent,
    hourlyPrice: Optional[String] = Optional.Absent,
    instanceFamily: Optional[String] = Optional.Absent,
    paymentOption: Optional[zio.aws.ec2.model.PaymentOption] = Optional.Absent,
    upfrontPrice: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Purchase = {
    import Purchase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Purchase
      .builder()
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(
        hostIdSet.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.hostIdSet)
      .optionallyWith(
        hostReservationId.map(value =>
          HostReservationId.unwrap(value): java.lang.String
        )
      )(_.hostReservationId)
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(upfrontPrice.map(value => value: java.lang.String))(
        _.upfrontPrice
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Purchase.ReadOnly =
    zio.aws.ec2.model.Purchase.wrap(buildAwsValue())
}
object Purchase {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Purchase] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Purchase = zio.aws.ec2.model.Purchase(
      currencyCode.map(value => value),
      duration.map(value => value),
      hostIdSet.map(value => value),
      hostReservationId.map(value => value),
      hourlyPrice.map(value => value),
      instanceFamily.map(value => value),
      paymentOption.map(value => value),
      upfrontPrice.map(value => value)
    )
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def duration: Optional[Integer]
    def hostIdSet: Optional[List[String]]
    def hostReservationId: Optional[HostReservationId]
    def hourlyPrice: Optional[String]
    def instanceFamily: Optional[String]
    def paymentOption: Optional[zio.aws.ec2.model.PaymentOption]
    def upfrontPrice: Optional[String]
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getHostIdSet: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("hostIdSet", hostIdSet)
    def getHostReservationId: ZIO[Any, AwsError, HostReservationId] =
      AwsError.unwrapOptionField("hostReservationId", hostReservationId)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getPaymentOption: ZIO[Any, AwsError, zio.aws.ec2.model.PaymentOption] =
      AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getUpfrontPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("upfrontPrice", upfrontPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Purchase
  ) extends zio.aws.ec2.model.Purchase.ReadOnly {
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val duration: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Integer)
    override val hostIdSet: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.hostIdSet())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val hostReservationId: Optional[HostReservationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostReservationId())
        .map(value => zio.aws.ec2.model.primitives.HostReservationId(value))
    override val hourlyPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hourlyPrice())
      .map(value => value: String)
    override val instanceFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFamily())
      .map(value => value: String)
    override val paymentOption: Optional[zio.aws.ec2.model.PaymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paymentOption())
        .map(value => zio.aws.ec2.model.PaymentOption.wrap(value))
    override val upfrontPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.upfrontPrice())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Purchase
  ): zio.aws.ec2.model.Purchase.ReadOnly = new Wrapper(impl)
}
