package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, InstanceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ModifyInstanceEventStartTimeRequest(
    instanceId: InstanceId,
    instanceEventId: String,
    notBefore: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest = {
    import ModifyInstanceEventStartTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .instanceEventId(instanceEventId: java.lang.String)
      .notBefore(DateTime.unwrap(notBefore): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest.wrap(buildAwsValue())
}
object ModifyInstanceEventStartTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest =
      zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest(
        instanceId,
        instanceEventId,
        notBefore
      )
    def instanceId: InstanceId
    def instanceEventId: String
    def notBefore: DateTime
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getInstanceEventId: ZIO[Any, Nothing, String] =
      ZIO.succeed(instanceEventId)
    def getNotBefore: ZIO[Any, Nothing, DateTime] = ZIO.succeed(notBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest
  ) extends zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val instanceEventId: String = impl.instanceEventId(): String
    override val notBefore: DateTime =
      zio.aws.ec2.model.primitives.DateTime(impl.notBefore())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest
  ): zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest.ReadOnly =
    new Wrapper(impl)
}
