package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVpnTunnelReplacementStatusRequest(
    vpnConnectionId: VpnConnectionId,
    vpnTunnelOutsideIpAddress: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest = {
    import GetVpnTunnelReplacementStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .vpnTunnelOutsideIpAddress(vpnTunnelOutsideIpAddress: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVpnTunnelReplacementStatusRequest.ReadOnly =
    zio.aws.ec2.model.GetVpnTunnelReplacementStatusRequest.wrap(buildAwsValue())
}
object GetVpnTunnelReplacementStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVpnTunnelReplacementStatusRequest =
      zio.aws.ec2.model.GetVpnTunnelReplacementStatusRequest(
        vpnConnectionId,
        vpnTunnelOutsideIpAddress
      )
    def vpnConnectionId: VpnConnectionId
    def vpnTunnelOutsideIpAddress: String
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getVpnTunnelOutsideIpAddress: ZIO[Any, Nothing, String] =
      ZIO.succeed(vpnTunnelOutsideIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest
  ) extends zio.aws.ec2.model.GetVpnTunnelReplacementStatusRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val vpnTunnelOutsideIpAddress: String =
      impl.vpnTunnelOutsideIpAddress(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest
  ): zio.aws.ec2.model.GetVpnTunnelReplacementStatusRequest.ReadOnly =
    new Wrapper(impl)
}
