package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPasswordDataRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest = {
    import GetPasswordDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetPasswordDataRequest.ReadOnly =
    zio.aws.ec2.model.GetPasswordDataRequest.wrap(buildAwsValue())
}
object GetPasswordDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetPasswordDataRequest =
      zio.aws.ec2.model.GetPasswordDataRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest
  ) extends zio.aws.ec2.model.GetPasswordDataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest
  ): zio.aws.ec2.model.GetPasswordDataRequest.ReadOnly = new Wrapper(impl)
}
