package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEbsEncryptionByDefaultResponse(
    ebsEncryptionByDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse = {
    import GetEbsEncryptionByDefaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse
      .builder()
      .optionallyWith(
        ebsEncryptionByDefault.map(value => value: java.lang.Boolean)
      )(_.ebsEncryptionByDefault)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly =
    zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.wrap(buildAwsValue())
}
object GetEbsEncryptionByDefaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse =
      zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse(
        ebsEncryptionByDefault.map(value => value)
      )
    def ebsEncryptionByDefault: Optional[Boolean]
    def getEbsEncryptionByDefault: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("ebsEncryptionByDefault", ebsEncryptionByDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse
  ) extends zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly {
    override val ebsEncryptionByDefault: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsEncryptionByDefault())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse
  ): zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly = new Wrapper(
    impl
  )
}
