package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCapacityReservationUsageResponse(
    nextToken: Optional[String] = Optional.Absent,
    capacityReservationId: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    totalInstanceCount: Optional[Integer] = Optional.Absent,
    availableInstanceCount: Optional[Integer] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.CapacityReservationState] =
      Optional.Absent,
    instanceUsages: Optional[Iterable[zio.aws.ec2.model.InstanceUsage]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse = {
    import GetCapacityReservationUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        capacityReservationId.map(value => value: java.lang.String)
      )(_.capacityReservationId)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        totalInstanceCount.map(value => value: java.lang.Integer)
      )(_.totalInstanceCount)
      .optionallyWith(
        availableInstanceCount.map(value => value: java.lang.Integer)
      )(_.availableInstanceCount)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        instanceUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceUsages)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly =
    zio.aws.ec2.model.GetCapacityReservationUsageResponse.wrap(buildAwsValue())
}
object GetCapacityReservationUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetCapacityReservationUsageResponse =
      zio.aws.ec2.model.GetCapacityReservationUsageResponse(
        nextToken.map(value => value),
        capacityReservationId.map(value => value),
        instanceType.map(value => value),
        totalInstanceCount.map(value => value),
        availableInstanceCount.map(value => value),
        state.map(value => value),
        instanceUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def capacityReservationId: Optional[String]
    def instanceType: Optional[String]
    def totalInstanceCount: Optional[Integer]
    def availableInstanceCount: Optional[Integer]
    def state: Optional[zio.aws.ec2.model.CapacityReservationState]
    def instanceUsages: Optional[List[zio.aws.ec2.model.InstanceUsage.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCapacityReservationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getTotalInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalInstanceCount", totalInstanceCount)
    def getAvailableInstanceCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("availableInstanceCount", availableInstanceCount)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationState] =
      AwsError.unwrapOptionField("state", state)
    def getInstanceUsages
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceUsage.ReadOnly]] =
      AwsError.unwrapOptionField("instanceUsages", instanceUsages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse
  ) extends zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val capacityReservationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationId())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val totalInstanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalInstanceCount())
      .map(value => value: Integer)
    override val availableInstanceCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableInstanceCount())
        .map(value => value: Integer)
    override val state: Optional[zio.aws.ec2.model.CapacityReservationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.CapacityReservationState.wrap(value))
    override val instanceUsages
        : Optional[List[zio.aws.ec2.model.InstanceUsage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceUsage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse
  ): zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly =
    new Wrapper(impl)
}
