package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetSpotCapacityRebalance(
    replacementStrategy: Optional[zio.aws.ec2.model.FleetReplacementStrategy] =
      Optional.Absent,
    terminationDelay: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalance = {
    import FleetSpotCapacityRebalance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalance
      .builder()
      .optionallyWith(replacementStrategy.map(value => value.unwrap))(
        _.replacementStrategy
      )
      .optionallyWith(terminationDelay.map(value => value: java.lang.Integer))(
        _.terminationDelay
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetSpotCapacityRebalance.ReadOnly =
    zio.aws.ec2.model.FleetSpotCapacityRebalance.wrap(buildAwsValue())
}
object FleetSpotCapacityRebalance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetSpotCapacityRebalance =
      zio.aws.ec2.model.FleetSpotCapacityRebalance(
        replacementStrategy.map(value => value),
        terminationDelay.map(value => value)
      )
    def replacementStrategy
        : Optional[zio.aws.ec2.model.FleetReplacementStrategy]
    def terminationDelay: Optional[Integer]
    def getReplacementStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetReplacementStrategy] =
      AwsError.unwrapOptionField("replacementStrategy", replacementStrategy)
    def getTerminationDelay: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("terminationDelay", terminationDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalance
  ) extends zio.aws.ec2.model.FleetSpotCapacityRebalance.ReadOnly {
    override val replacementStrategy
        : Optional[zio.aws.ec2.model.FleetReplacementStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replacementStrategy())
        .map(value => zio.aws.ec2.model.FleetReplacementStrategy.wrap(value))
    override val terminationDelay: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationDelay())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotCapacityRebalance
  ): zio.aws.ec2.model.FleetSpotCapacityRebalance.ReadOnly = new Wrapper(impl)
}
