package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  TrafficMirroringMaxResults,
  TrafficMirrorFilterId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeTrafficMirrorFiltersRequest(
    trafficMirrorFilterIds: Optional[Iterable[TrafficMirrorFilterId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[TrafficMirroringMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest = {
    import DescribeTrafficMirrorFiltersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
      .builder()
      .optionallyWith(
        trafficMirrorFilterIds.map(value =>
          value.map { item =>
            TrafficMirrorFilterId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trafficMirrorFilterIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          TrafficMirroringMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.wrap(buildAwsValue())
}
object DescribeTrafficMirrorFiltersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest =
      zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest(
        trafficMirrorFilterIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def trafficMirrorFilterIds: Optional[List[TrafficMirrorFilterId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[TrafficMirroringMaxResults]
    def nextToken: Optional[NextToken]
    def getTrafficMirrorFilterIds
        : ZIO[Any, AwsError, List[TrafficMirrorFilterId]] = AwsError
      .unwrapOptionField("trafficMirrorFilterIds", trafficMirrorFilterIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TrafficMirroringMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
  ) extends zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.ReadOnly {
    override val trafficMirrorFilterIds: Optional[List[TrafficMirrorFilterId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorFilterIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.TrafficMirrorFilterId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[TrafficMirroringMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.TrafficMirroringMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest
  ): zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest.ReadOnly =
    new Wrapper(impl)
}
