package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SecurityGroupName, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSecurityGroupRequest(
    groupId: Optional[SecurityGroupId] = Optional.Absent,
    groupName: Optional[SecurityGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest = {
    import DeleteSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest
      .builder()
      .optionallyWith(
        groupId.map(value => SecurityGroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupName.map(value =>
          SecurityGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteSecurityGroupRequest.ReadOnly =
    zio.aws.ec2.model.DeleteSecurityGroupRequest.wrap(buildAwsValue())
}
object DeleteSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSecurityGroupRequest =
      zio.aws.ec2.model.DeleteSecurityGroupRequest(
        groupId.map(value => value),
        groupName.map(value => value)
      )
    def groupId: Optional[SecurityGroupId]
    def groupName: Optional[SecurityGroupName]
    def getGroupId: ZIO[Any, AwsError, SecurityGroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, SecurityGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest
  ) extends zio.aws.ec2.model.DeleteSecurityGroupRequest.ReadOnly {
    override val groupId: Optional[SecurityGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupId(value))
    override val groupName: Optional[SecurityGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.SecurityGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest
  ): zio.aws.ec2.model.DeleteSecurityGroupRequest.ReadOnly = new Wrapper(impl)
}
