package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CapacityReservationSpecificationResponse(
    capacityReservationPreference: Optional[
      zio.aws.ec2.model.CapacityReservationPreference
    ] = Optional.Absent,
    capacityReservationTarget: Optional[
      zio.aws.ec2.model.CapacityReservationTargetResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationSpecificationResponse = {
    import CapacityReservationSpecificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationSpecificationResponse
      .builder()
      .optionallyWith(capacityReservationPreference.map(value => value.unwrap))(
        _.capacityReservationPreference
      )
      .optionallyWith(
        capacityReservationTarget.map(value => value.buildAwsValue())
      )(_.capacityReservationTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly =
    zio.aws.ec2.model.CapacityReservationSpecificationResponse
      .wrap(buildAwsValue())
}
object CapacityReservationSpecificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationSpecificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationSpecificationResponse =
      zio.aws.ec2.model.CapacityReservationSpecificationResponse(
        capacityReservationPreference.map(value => value),
        capacityReservationTarget.map(value => value.asEditable)
      )
    def capacityReservationPreference
        : Optional[zio.aws.ec2.model.CapacityReservationPreference]
    def capacityReservationTarget
        : Optional[zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly]
    def getCapacityReservationPreference
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationPreference] =
      AwsError.unwrapOptionField(
        "capacityReservationPreference",
        capacityReservationPreference
      )
    def getCapacityReservationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationTarget",
      capacityReservationTarget
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationSpecificationResponse
  ) extends zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly {
    override val capacityReservationPreference
        : Optional[zio.aws.ec2.model.CapacityReservationPreference] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationPreference())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationPreference.wrap(value)
        )
    override val capacityReservationTarget: Optional[
      zio.aws.ec2.model.CapacityReservationTargetResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationTarget())
      .map(value =>
        zio.aws.ec2.model.CapacityReservationTargetResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationSpecificationResponse
  ): zio.aws.ec2.model.CapacityReservationSpecificationResponse.ReadOnly =
    new Wrapper(impl)
}
