package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AllocationStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.AllocationStrategy
}
object AllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AllocationStrategy
  ): zio.aws.ec2.model.AllocationStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.AllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AllocationStrategy.LOWEST_PRICE =>
      val r = lowestPrice
      r
    case software.amazon.awssdk.services.ec2.model.AllocationStrategy.DIVERSIFIED =>
      val r = diversified
      r
    case software.amazon.awssdk.services.ec2.model.AllocationStrategy.CAPACITY_OPTIMIZED =>
      val r = capacityOptimized
      r
    case software.amazon.awssdk.services.ec2.model.AllocationStrategy.CAPACITY_OPTIMIZED_PRIORITIZED =>
      val r = capacityOptimizedPrioritized
      r
    case software.amazon.awssdk.services.ec2.model.AllocationStrategy.PRICE_CAPACITY_OPTIMIZED =>
      val r = priceCapacityOptimized
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationStrategy =
      software.amazon.awssdk.services.ec2.model.AllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object lowestPrice extends zio.aws.ec2.model.AllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationStrategy =
      software.amazon.awssdk.services.ec2.model.AllocationStrategy.LOWEST_PRICE
  }
  case object diversified extends zio.aws.ec2.model.AllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationStrategy =
      software.amazon.awssdk.services.ec2.model.AllocationStrategy.DIVERSIFIED
  }
  case object capacityOptimized extends zio.aws.ec2.model.AllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationStrategy =
      software.amazon.awssdk.services.ec2.model.AllocationStrategy.CAPACITY_OPTIMIZED
  }
  case object capacityOptimizedPrioritized
      extends zio.aws.ec2.model.AllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationStrategy =
      software.amazon.awssdk.services.ec2.model.AllocationStrategy.CAPACITY_OPTIMIZED_PRIORITIZED
  }
  case object priceCapacityOptimized
      extends zio.aws.ec2.model.AllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationStrategy =
      software.amazon.awssdk.services.ec2.model.AllocationStrategy.PRICE_CAPACITY_OPTIMIZED
  }
}
