package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionIdWithResolver
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AcceptVpcPeeringConnectionRequest(
    vpcPeeringConnectionId: VpcPeeringConnectionIdWithResolver
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest = {
    import AcceptVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
      .builder()
      .vpcPeeringConnectionId(
        VpcPeeringConnectionIdWithResolver.unwrap(
          vpcPeeringConnectionId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object AcceptVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest =
      zio.aws.ec2.model
        .AcceptVpcPeeringConnectionRequest(vpcPeeringConnectionId)
    def vpcPeeringConnectionId: VpcPeeringConnectionIdWithResolver
    def getVpcPeeringConnectionId
        : ZIO[Any, Nothing, VpcPeeringConnectionIdWithResolver] =
      ZIO.succeed(vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly {
    override val vpcPeeringConnectionId: VpcPeeringConnectionIdWithResolver =
      zio.aws.ec2.model.primitives
        .VpcPeeringConnectionIdWithResolver(impl.vpcPeeringConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
