package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Vpc(
    cidrBlock: Optional[String] = Optional.Absent,
    dhcpOptionsId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.VpcState] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] = Optional.Absent,
    ipv6CidrBlockAssociationSet: Optional[
      Iterable[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation]
    ] = Optional.Absent,
    cidrBlockAssociationSet: Optional[
      Iterable[zio.aws.ec2.model.VpcCidrBlockAssociation]
    ] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Vpc = {
    import Vpc.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Vpc
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(dhcpOptionsId.map(value => value: java.lang.String))(
        _.dhcpOptionsId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(
        ipv6CidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6CidrBlockAssociationSet)
      .optionallyWith(
        cidrBlockAssociationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrBlockAssociationSet)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Vpc.ReadOnly =
    zio.aws.ec2.model.Vpc.wrap(buildAwsValue())
}
object Vpc {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Vpc] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Vpc = zio.aws.ec2.model.Vpc(
      cidrBlock.map(value => value),
      dhcpOptionsId.map(value => value),
      state.map(value => value),
      vpcId.map(value => value),
      ownerId.map(value => value),
      instanceTenancy.map(value => value),
      ipv6CidrBlockAssociationSet.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      cidrBlockAssociationSet.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      isDefault.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def cidrBlock: Optional[String]
    def dhcpOptionsId: Optional[String]
    def state: Optional[zio.aws.ec2.model.VpcState]
    def vpcId: Optional[String]
    def ownerId: Optional[String]
    def instanceTenancy: Optional[zio.aws.ec2.model.Tenancy]
    def ipv6CidrBlockAssociationSet
        : Optional[List[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly]]
    def cidrBlockAssociationSet
        : Optional[List[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly]]
    def isDefault: Optional[Boolean]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getDhcpOptionsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dhcpOptionsId", dhcpOptionsId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpcState] =
      AwsError.unwrapOptionField("state", state)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getIpv6CidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipv6CidrBlockAssociationSet",
      ipv6CidrBlockAssociationSet
    )
    def getCidrBlockAssociationSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cidrBlockAssociationSet",
      cidrBlockAssociationSet
    )
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Vpc
  ) extends zio.aws.ec2.model.Vpc.ReadOnly {
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val dhcpOptionsId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dhcpOptionsId())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.VpcState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.VpcState.wrap(value))
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTenancy())
        .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val ipv6CidrBlockAssociationSet: Optional[
      List[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlockAssociationSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.wrap(item)
        }.toList
      )
    override val cidrBlockAssociationSet
        : Optional[List[zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrBlockAssociationSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpcCidrBlockAssociation.wrap(item)
          }.toList
        )
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Vpc
  ): zio.aws.ec2.model.Vpc.ReadOnly = new Wrapper(impl)
}
