package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayPolicyTableState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState
}
object TransitGatewayPolicyTableState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState
  ): zio.aws.ec2.model.TransitGatewayPolicyTableState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayPolicyTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.TransitGatewayPolicyTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.PENDING
  }
  case object available
      extends zio.aws.ec2.model.TransitGatewayPolicyTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.AVAILABLE
  }
  case object deleting
      extends zio.aws.ec2.model.TransitGatewayPolicyTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.TransitGatewayPolicyTableState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableState.DELETED
  }
}
