package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayAttachmentAssociation(
    transitGatewayRouteTableId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayAssociationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation = {
    import TransitGatewayAttachmentAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
      .builder()
      .optionallyWith(
        transitGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.transitGatewayRouteTableId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayAttachmentAssociation.wrap(buildAwsValue())
}
object TransitGatewayAttachmentAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayAttachmentAssociation =
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation(
        transitGatewayRouteTableId.map(value => value),
        state.map(value => value)
      )
    def transitGatewayRouteTableId: Optional[String]
    def state: Optional[zio.aws.ec2.model.TransitGatewayAssociationState]
    def getTransitGatewayRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAssociationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
  ) extends zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly {
    override val transitGatewayRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableId())
        .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAssociationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentAssociation
  ): zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly =
    new Wrapper(impl)
}
