package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TerminateConnectionStatus(
    connectionId: Optional[String] = Optional.Absent,
    previousStatus: Optional[zio.aws.ec2.model.ClientVpnConnectionStatus] =
      Optional.Absent,
    currentStatus: Optional[zio.aws.ec2.model.ClientVpnConnectionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus = {
    import TerminateConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
      .builder()
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(previousStatus.map(value => value.buildAwsValue()))(
        _.previousStatus
      )
      .optionallyWith(currentStatus.map(value => value.buildAwsValue()))(
        _.currentStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly =
    zio.aws.ec2.model.TerminateConnectionStatus.wrap(buildAwsValue())
}
object TerminateConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateConnectionStatus =
      zio.aws.ec2.model.TerminateConnectionStatus(
        connectionId.map(value => value),
        previousStatus.map(value => value.asEditable),
        currentStatus.map(value => value.asEditable)
      )
    def connectionId: Optional[String]
    def previousStatus
        : Optional[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly]
    def currentStatus
        : Optional[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly]
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getPreviousStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("previousStatus", previousStatus)
    def getCurrentStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("currentStatus", currentStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
  ) extends zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly {
    override val connectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => value: String)
    override val previousStatus
        : Optional[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousStatus())
        .map(value => zio.aws.ec2.model.ClientVpnConnectionStatus.wrap(value))
    override val currentStatus
        : Optional[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentStatus())
        .map(value => zio.aws.ec2.model.ClientVpnConnectionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
  ): zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly = new Wrapper(impl)
}
