package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuccessfulQueuedPurchaseDeletion(
    reservedInstancesId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SuccessfulQueuedPurchaseDeletion = {
    import SuccessfulQueuedPurchaseDeletion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SuccessfulQueuedPurchaseDeletion
      .builder()
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.ReadOnly =
    zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.wrap(buildAwsValue())
}
object SuccessfulQueuedPurchaseDeletion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SuccessfulQueuedPurchaseDeletion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion =
      zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion(
        reservedInstancesId.map(value => value)
      )
    def reservedInstancesId: Optional[String]
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SuccessfulQueuedPurchaseDeletion
  ) extends zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.ReadOnly {
    override val reservedInstancesId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstancesId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SuccessfulQueuedPurchaseDeletion
  ): zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion.ReadOnly = new Wrapper(
    impl
  )
}
