package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class SpotMarketOptions(
    maxPrice: Optional[String] = Optional.Absent,
    spotInstanceType: Optional[zio.aws.ec2.model.SpotInstanceType] =
      Optional.Absent,
    blockDurationMinutes: Optional[Integer] = Optional.Absent,
    validUntil: Optional[DateTime] = Optional.Absent,
    instanceInterruptionBehavior: Optional[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotMarketOptions = {
    import SpotMarketOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotMarketOptions
      .builder()
      .optionallyWith(maxPrice.map(value => value: java.lang.String))(
        _.maxPrice
      )
      .optionallyWith(spotInstanceType.map(value => value.unwrap))(
        _.spotInstanceType
      )
      .optionallyWith(
        blockDurationMinutes.map(value => value: java.lang.Integer)
      )(_.blockDurationMinutes)
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotMarketOptions.ReadOnly =
    zio.aws.ec2.model.SpotMarketOptions.wrap(buildAwsValue())
}
object SpotMarketOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotMarketOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotMarketOptions =
      zio.aws.ec2.model.SpotMarketOptions(
        maxPrice.map(value => value),
        spotInstanceType.map(value => value),
        blockDurationMinutes.map(value => value),
        validUntil.map(value => value),
        instanceInterruptionBehavior.map(value => value)
      )
    def maxPrice: Optional[String]
    def spotInstanceType: Optional[zio.aws.ec2.model.SpotInstanceType]
    def blockDurationMinutes: Optional[Integer]
    def validUntil: Optional[DateTime]
    def instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def getMaxPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxPrice", maxPrice)
    def getSpotInstanceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceType] =
      AwsError.unwrapOptionField("spotInstanceType", spotInstanceType)
    def getBlockDurationMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotMarketOptions
  ) extends zio.aws.ec2.model.SpotMarketOptions.ReadOnly {
    override val maxPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxPrice())
      .map(value => value: String)
    override val spotInstanceType
        : Optional[zio.aws.ec2.model.SpotInstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.spotInstanceType())
      .map(value => zio.aws.ec2.model.SpotInstanceType.wrap(value))
    override val blockDurationMinutes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDurationMinutes())
      .map(value => value: Integer)
    override val validUntil: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInterruptionBehavior())
        .map(value =>
          zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotMarketOptions
  ): zio.aws.ec2.model.SpotMarketOptions.ReadOnly = new Wrapper(impl)
}
