package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroup(
    description: Optional[String] = Optional.Absent,
    groupName: Optional[String] = Optional.Absent,
    ipPermissions: Optional[Iterable[zio.aws.ec2.model.IpPermission]] =
      Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    groupId: Optional[String] = Optional.Absent,
    ipPermissionsEgress: Optional[Iterable[zio.aws.ec2.model.IpPermission]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroup = {
    import SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroup
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissionsEgress)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroup.ReadOnly =
    zio.aws.ec2.model.SecurityGroup.wrap(buildAwsValue())
}
object SecurityGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.SecurityGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroup =
      zio.aws.ec2.model.SecurityGroup(
        description.map(value => value),
        groupName.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        groupId.map(value => value),
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def description: Optional[String]
    def groupName: Optional[String]
    def ipPermissions: Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def ownerId: Optional[String]
    def groupId: Optional[String]
    def ipPermissionsEgress
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getIpPermissionsEgress
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissionsEgress", ipPermissionsEgress)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroup
  ) extends zio.aws.ec2.model.SecurityGroup.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val ipPermissions
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpPermission.wrap(item)
          }.toList
        )
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val ipPermissionsEgress
        : Optional[List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipPermissionsEgress())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpPermission.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroup
  ): zio.aws.ec2.model.SecurityGroup.ReadOnly = new Wrapper(impl)
}
