package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupTypePair(
    ruleGroupArn: Optional[ResourceArn] = Optional.Absent,
    ruleGroupType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RuleGroupTypePair = {
    import RuleGroupTypePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RuleGroupTypePair
      .builder()
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(ruleGroupType.map(value => value: java.lang.String))(
        _.ruleGroupType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RuleGroupTypePair.ReadOnly =
    zio.aws.ec2.model.RuleGroupTypePair.wrap(buildAwsValue())
}
object RuleGroupTypePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RuleGroupTypePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RuleGroupTypePair =
      zio.aws.ec2.model.RuleGroupTypePair(
        ruleGroupArn.map(value => value),
        ruleGroupType.map(value => value)
      )
    def ruleGroupArn: Optional[ResourceArn]
    def ruleGroupType: Optional[String]
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getRuleGroupType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleGroupType", ruleGroupType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RuleGroupTypePair
  ) extends zio.aws.ec2.model.RuleGroupTypePair.ReadOnly {
    override val ruleGroupArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ruleGroupType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RuleGroupTypePair
  ): zio.aws.ec2.model.RuleGroupTypePair.ReadOnly = new Wrapper(impl)
}
