package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuleGroupRuleOptionsPair(
    ruleGroupArn: Optional[ResourceArn] = Optional.Absent,
    ruleOptions: Optional[Iterable[zio.aws.ec2.model.RuleOption]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair = {
    import RuleGroupRuleOptionsPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair
      .builder()
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(
        ruleOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RuleGroupRuleOptionsPair.ReadOnly =
    zio.aws.ec2.model.RuleGroupRuleOptionsPair.wrap(buildAwsValue())
}
object RuleGroupRuleOptionsPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RuleGroupRuleOptionsPair =
      zio.aws.ec2.model.RuleGroupRuleOptionsPair(
        ruleGroupArn.map(value => value),
        ruleOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ruleGroupArn: Optional[ResourceArn]
    def ruleOptions: Optional[List[zio.aws.ec2.model.RuleOption.ReadOnly]]
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getRuleOptions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RuleOption.ReadOnly]] =
      AwsError.unwrapOptionField("ruleOptions", ruleOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair
  ) extends zio.aws.ec2.model.RuleGroupRuleOptionsPair.ReadOnly {
    override val ruleGroupArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ruleOptions
        : Optional[List[zio.aws.ec2.model.RuleOption.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RuleOption.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair
  ): zio.aws.ec2.model.RuleGroupRuleOptionsPair.ReadOnly = new Wrapper(impl)
}
